{ A form to view and edit the parameters. This form contains a panel (containing
  buttons) and a mypagecontrol object. The mypagecontrol object contains
  a page (a MyTabSheet object) for each process defined in equations.pas that
  has parameters associated with it. The mypagecontrol and mytabsheet objects
  are descendents of the PageControl and TabSheet objects defined by Delphi.
  Their full definitions are located in the newcontrols.pas file of this project.
  Each MyTabSheet contains 3 labels across the top for the process name, value
  and units, respectively and a stringgrid to store and allow modifications of
  the parameter values.
   }

unit params;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ComCtrls, Grids, bkPageControl, ExtCtrls;

type
  TFmParameter = class(TForm)
    PlBottom: TPanel;
    BtnUpdateProc: TButton;
    BtnOK: TButton;
    BtnClose: TButton;
    BtnShowAllProcess: TButton;
    BtnCalcParams: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure updateparams;
    procedure BtnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CalculateProcesses;
    procedure BtnUpdateProcClick(Sender: TObject);
    procedure BtnShowAllProcessClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure StringGridSelectCell(Sender: TObject; Col,
                                         Row: Integer; var CanSelect: Boolean);
    procedure BtnCalcParamsClick(Sender: TObject);
    function UpdateProcesses(Sender: TObject):Boolean;
//    procedure StringGridDrawCell(Sender: TObject; Col, Row: Integer;
//                                         Rect: TRect; State: TGridDrawState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FmParameter: TFmParameter;
  PgCtData: TbkPageControl;
  CurrentSheet : TbkTabSheet;
  Alreadywarned:Boolean = False;

implementation

{$R *.DFM}

uses stypes, fileio, frontend, equations, data;

{ This procedure creates the pagecontrol with the appropriate number of
  tabsheets. }
procedure TFmParameter.FormCreate(Sender: TObject);
var
  i,k,npar: integer;
begin
  PgCtData := TbkPageControl.Create(Self);   // Create the pagecontrol
  PgCtData.Parent := Self;    // Parent is the Parameter Form
  PgCtData.Align := alClient;  // Have pagecontrol fill available space on
  PgCtData.Height := 330;
  PgCtData.MultiLine := True;  // Show all tabs
  PgCtData.TabWidth := smallint(round(0.7*stringlength*font.Size));
  // Add the appropriate number of tabsheets to the pagecontrol and fill the
  // string grid on the tabsheet with the parameter names for that process.
  for i := modeldef.numstate + 1 to modeldef.numprocess do
   begin     // for each process of the model
    if proc[i].parameters <> 0 then   // if the process has parameters
     with TbkTabSheet.Create(PgCtData) do  // create a tabsheet for the process
     begin
      Parent := PgCtData ;  // Set the tabsheet's parent to the pagecontrol
      Name := 'Ts' + inttostr(i-modeldef.numstate); // Set the tabsheets name
      PageControl := PgCtData; // Set the pagecontrol the tabsheet belongs to
      Caption := proc[i].name; // Tabsheet title
        // Set the first label to the process name
      LblProcessName.Caption := proc[i].symbol;
        // Set the first label to the process units
      LblProcessUnits.caption := proc[i].units;
       // Set the options on the string grid
      SgParams.Options := [goFixedVertLine,goFixedHorzLine,goVertLine,
        goHorzLine,goColSizing,goEditing,goAlwaysShowEditor,goThumbTracking] ;
      SgParams.Col := 2;
      SgParams.Row := 1;
      SgParams.OnSelectCell := StringGridSelectCell;
//      SgParams.OnDrawCell := DataForm.AdvStringGrid1DrawCell;
      // Count the number of parameters in all processes up to this process
      npar := ParCount(i);
      for k := 1 to proc[i].parameters do  // for each parameter in this process
        begin
       // Set the size of the stringgrid to 1 more than the number of parameters
         SgParams.RowCount := proc[i].parameters + 1;
         SgParams.Cells[0,k] := par[npar+k].symbol;; // Parameter symbol
         SgParams.Cells[1,k] := par[npar+k].name;  // Parameter name
         SgParams.Cells[2,k] := floattostr(par[npar+k].value); // Parameter value
         SgParams.Cells[3,k] := par[npar+k].units; // Parameter units
        end;
      case proc[i].ptype of
        ptGroup1:
         begin
          TabColor := clGreen;
          TabFontColor := clWhite;
         end;
        ptGroup2:
         begin
          TabColor := clTeal;
          TabFontColor := clWhite;
         end;
        ptGroup3:
         begin
          TabColor := clMaroon;
          TabFontColor := clWhite;
         end;
        ptGroup4:
         begin
          TabColor := clNavy;
          TabFontColor := clWhite;
         end;
        ptGroup5:
         begin
          TabColor := clSilver;
          TabFontColor := clBlack;
         end;
      end;
     end;
   end;
end;

{ Free the memory allocated for the PageControl when this form is destroyed. }
procedure TFmParameter.FormDestroy(Sender: TObject);
begin
 PgCtData.Free;
end;

{ Update process values if possible and then display the current values of the
  processes and parameters in the form. }
procedure TFmParameter.FormShow(Sender: TObject);
var
 i,procnum,npage,prevpar:integer;
begin
  if Sender <> BtnUpdateProc then
   begin
    Alreadywarned := False;
    BtnClose.Caption := '&Cancel';
   end;
  { Set the form caption to include the parameter filename to remind the user
   which file they are working with. }
  FmParameter.Caption := 'Parameters - File: ' + paramfilename;
 { If no driver file was chosen don't attempt to calculate processes, just show
   the form with the current values of the parameters. }
  if driverfilename = '' then
    MessageDlg('No Driver File. Process values will not be calculated.',
                      mtWarning, [mbOK], 0)
  else  // Driver file was chosen so calculate processes.
   { Try to calculate the processes, on any errors, display message and then
     continue. }
    if not (NewParamFile or NewDriverFile) then
      try CalculateProcesses;
      except MessageDlg('Invalid Parameter. Process values will not be calculated.',
                      mtWarning, [mbOK], 0);
    end;

// Update the form with the current process and parameter values.
  npage := 0;   // Start with the first page (or sheet) in the pagecontrol
   // For each process
  for procnum := ModelDef.numstate + 1 to ModelDef.numprocess do
   begin
    // If this process has parameters associated with it then s
    if proc[procnum].parameters <> 0 then
     begin
      // Set process value label at the top of the tabsheet to the current value
      // of the process.
      PgCtData.Pages[npage].LblProcessValue.Caption :=
         floattostrf(proc[procnum].value,ffgeneral,5,0);
     // Count the number of parameters in the previous process.
      prevpar := ParCount(procnum);
      i := 1; // Dummy to loop over parameters, start with parameter number 1
      // for each parameter of this process do
      while i <= proc[procnum].parameters do
       begin
        // Put the value of the parameter in the stringgrid
        PgCtData.Pages[npage].SgParams.cells[2,i] :=
         floattostr(par[prevpar + i].value);
        i := i + 1; // Next parameter
       end;
      npage := npage + 1;    // Next page (ie tabsheet)
     end;
   end;
end;

{ This procedure takes changes made to the parameters in the stringgrid and
  copies the new values of the parameters into the parameter array. }
procedure TFmParameter.updateparams;
var
 i,npage,prevpar,procnum:integer;
begin
  npage := 0;  // Start with the first page (or sheet) in the pagecontrol
  // For each process in the model
  for procnum := ModelDef.numstate + 1 to ModelDef.numprocess do
   begin
    if proc[procnum].parameters <> 0 then  // If the process has parameters
     begin
     // Count the parameters in the previous process
       prevpar := ParCount(procnum);
   // For each parameter copy the value in the stringgrid to the parameter array
       for i := 1 to proc[procnum].parameters do
         par[prevpar + i].value :=
             strtofloat(PgCtData.Pages[npage].SgParams.cells[2,i]);
       npage := npage + 1;   // Next page (ie tabsheet)
     end;
   end;
  NeedToSavePar := true;
end;

{ If the user clicks OK, save changes made to the parameters, close this form
  and if the dataform is visible, close it also. }
procedure TFmParameter.BtnOKClick(Sender: TObject);
begin
 Updateparams;   // Save parameter values
 if Dataform.Visible then Dataform.Hide;  // Close dataform if necessary.
end;

{ Calculate process values. }
procedure TFmParameter.CalculateProcesses;
begin
  // Open driverfile, read first row of drivers, and then close the driver file.
  OpenDriverFile(driverfilename,ModelDef.numdrive,drive,flread);
  last_time := 0;
  next_time := 0;
  GetCurrentDrivers(Caltime,drive);
  CloseDriverFile;
  processes(Caltime,caltime,drive,par,stat,proc,false); // Calculate processes
end;

{ User has modified parameter values and wants to see the new process values. }
procedure TFmParameter.BtnUpdateProcClick(Sender: TObject);
begin
 UpdateProcesses(BtnUpdateProc)
end;

function TFmParameter.UpdateProcesses(Sender: TObject):Boolean;
begin
 if not Alreadywarned then  // If the user has not save the previous parameter set
  // Warn them that previous values will be lost.
  begin
   if MessageDlg('Previous parameter values will be lost if you proceed. Continue?',
         mtWarning, mbOKCancel, 0) = mrCancel then
       begin
        UpdateProcesses := False;
        Exit;
       end;
   BtnClose.Caption := '&Close';
   Alreadywarned := True;
  end;
 UpdateParams;   // Update the parameters
 FormShow(BtnUpdateProc);  // and update the whole parameter form
 // If the dataform is visible (ie, the user is viewing processes in the dataform
 if (DataForm.Visible = True) and (DataShowing = dtprocess) then
   DataForm.UpdateProcess; // Update the process values on the dataform.
 UpdateProcesses := True;
end;

{ Show all processes in another window, but still allow the user to access and
  modify the parameter form. }
procedure TFmParameter.BtnShowAllProcessClick(Sender: TObject);
begin
 if UpdateProcesses(BtnShowAllProcess) = True then
   DataForm.ShowProcess;  // Show processes in the dataform.
end;

{ Close the form but don't save changes. Close the dataform if it's visible. }
procedure TFmParameter.BtnCloseClick(Sender: TObject);
begin
 if Dataform.Visible = True then
   Dataform.Hide;
end;

procedure TFmParameter.StringGridSelectCell(Sender: TObject; Col,
  Row: Integer; var CanSelect: Boolean);
begin
 if Col = 2 then
  CanSelect := True
 else
  CanSelect := False
end;

procedure TFmParameter.BtnCalcParamsClick(Sender: TObject);
begin
 UpdateParams;   // Update the parameters
 MainForm.MICalcSSClick(BtnCalcParams);

 FormShow(BtnUpdateProc);  // and update the whole parameter form
 // If the dataform is visible (ie, the user is viewing processes in the dataform
 if (DataForm.Visible = True) and (DataShowing = dtprocess) then
   DataForm.UpdateProcess; // Update the process values on the dataform.
end;

end.
